%------------------------------------------------------------------------------
% File     : LCL878^1 : TPTP v7.4.0. Released v5.2.0.
% Domain   : Logic Calculi (Doxastic multimodal logic)
% Problem  : Correspondence for axiom I
% Version  : [Ben11] axioms.
% English  :

% Refs     : [Ben11] Benzmueller (2011), Email to Geoff Sutcliffe
%          : [Ben11] Benzmueller (2011), Combining and Automating Classical
% Source   : [Ben11]
% Names    : Ex_7_3 [Ben11]

% Status   : Theorem
% Rating   : 0.14 v7.4.0, 0.22 v7.2.0, 0.12 v7.1.0, 0.25 v7.0.0, 0.14 v6.4.0, 0.17 v6.3.0, 0.20 v6.2.0, 0.14 v5.5.0, 0.17 v5.4.0, 0.40 v5.3.0, 0.80 v5.2.0
% Syntax   : Number of formulae    :   64 (   0 unit;  32 type;  31 defn)
%            Number of atoms       :  237 (  36 equality; 140 variable)
%            Maximal formula depth :   11 (   6 average)
%            Number of connectives :  137 (   4   ~;   4   |;   8   &; 111   @)
%                                         (   1 <=>;   9  =>;   0  <=;   0 <~>)
%                                         (   0  ~|;   0  ~&)
%            Number of type conns  :  173 ( 173   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   36 (  32   :;   0   =)
%            Number of variables   :   89 (   3 sgn;  33   !;   6   ?;  50   ^)
%                                         (  89   :;   0  !>;   0  ?*)
%                                         (   0  @-;   0  @+)
% SPC      : TH0_THM_EQU_NAR

% Comments : 
%------------------------------------------------------------------------------
%----Include simple maths definitions and axioms
include('Axioms/LCL013^0.ax').
%------------------------------------------------------------------------------
%----Conjecture
thf(conj,conjecture,(
    ! [I: $i > $i > $o,J: $i > $i > $o] :
      ( ( mvalid
        @ ( mforall_prop
          @ ^ [Phi: $i > $o] :
              ( mimplies @ ( mbox @ I @ Phi ) @ ( mbox @ J @ Phi ) ) ) )
    <=> ! [U: $i,V: $i] :
          ( ( J @ U @ V )
         => ( I @ U @ V ) ) ) )).

%------------------------------------------------------------------------------
